#include <xtl.h>
#include <xui.h>
#include <xuiapp.h>
#include <fstream>
#include "tools.h"
#include "scnmain.h"
#include "scngames.h"
#include "contentlist.h"
#include "scngenres.h"
#include "loadingthread.h"
#include "scnloading.h"
#include "scngamedetails.h"
#include "freestyledash.h"
#include "ScnPickPath.h"
#include "ScnOptions.h"
#include "scnscreenshots.h"
#include "scnutilities.h"
#include "ftpserver.h"
#include "scnFileOp.h"
#include "scnfilebrowser.h"
#include "ScnAppConfig.h"
#include "fileslist.h"
#include "smc.h"
#include "ntp.cpp"

using namespace std;

D3DDevice *pDevice;

int Mounted[20];
wstring datapath;
wstring datapath_x;

/*Added by HellDoc 04/03/2010 - Semi Transparent background*/
int SemiTransparentBackground = 0;
int NTPonStartup = 0;
int HOverscan = 0;
int VOverscan = 0;
int FSpeed = 40;
int UseBackgrounds = 1;
int UsePreviews = 1;
int TempStatus = 1;
int Cels = 1;
int DiskStatus = 1;
int ShowStatus = 1;
int ParentalControl = 0;
int ShowIP = 1;
int DateFormat = 0;
int TimeFormat = 0;
int LedType = 0;
IDirect3DTexture9* gamerPic; 
LoadingThread* lt = NULL;
//string skin;
bool SaveSettings = false;
LEDState sTopLeft = OFF, 
		sTopRight = OFF, 
		sBottomLeft = OFF, 
		sBottomRight = OFF;

class CMyApp : public CXuiModule
{
protected:
    virtual HRESULT RegisterXuiClasses();
    virtual HRESULT UnregisterXuiClasses();



public:
    DWORD                               dwWidth;
    DWORD                               dwHeight;

	void GetVidMode();
	HRESULT Render();
};

void CMyApp::GetVidMode()
{
    XVIDEO_MODE VideoMode;
    XGetVideoMode( &VideoMode );

	DebugMsg("Vid Mode : %d x %d",VideoMode.dwDisplayWidth,VideoMode.dwDisplayHeight);

	dwWidth = VideoMode.dwDisplayWidth;
	dwHeight = VideoMode.dwDisplayHeight;
}

HRESULT CMyApp::Render()
{
	ASSERT(m_hDC != NULL);
	HRESULT hr = XuiRenderBegin(m_hDC, D3DCOLOR_ARGB(255, 0, 0, 0));
    if (FAILED(hr))
        return hr;

    D3DXMATRIX matOrigView;
    XuiRenderGetViewTransform( m_hDC, &matOrigView );

    // scale depending on the height of the render target
    D3DXMATRIX matView;
	int NewWidth = dwWidth - (HOverscan * 2);
	int NewHeight = dwHeight - (VOverscan * 2);
    D3DXVECTOR2 vScaling = D3DXVECTOR2( NewWidth / 1280.0f, NewHeight / 720.0f );
	D3DXVECTOR2 vTranslation = D3DXVECTOR2( (float)HOverscan, (float)VOverscan );
    D3DXMatrixTransformation2D( &matView, NULL, 0.0f, &vScaling, NULL, 0.0f, &vTranslation );
    XuiRenderSetViewTransform( m_hDC, &matView );



	
	XUIMessage msg;
    XUIMessageRender msgRender;
    XuiMessageRender(&msg, &msgRender, m_hDC, 0xffffffff, XUI_BLEND_NORMAL);
    XuiSendMessage(m_hObjRoot, &msg);

    XuiRenderSetViewTransform( m_hDC, &matOrigView );
	
	XuiRenderEnd(m_hDC);

	XuiRenderPresent(m_hDC, NULL, NULL, NULL);
	pDevice->Present( NULL, NULL, NULL, NULL );

	XuiTimersRun();	

    return S_OK;

}

HRESULT CMyApp::RegisterXuiClasses()
{
    CGamesList::Register();
    CGenreList::Register();
	CScnGames::Register();
	CScnGenres::Register();
	CScnLoading::Register();
	CScnGameDetails::Register();
 	CScnPickPath::Register();
 	CScnOptions::Register();
	CScnOptionsMainScreen::Register();
	CScnOptionsGameList::Register();
	CScnOptionsSystemSettings::Register();
	CScnOptionsChooseSkin::Register();
 	CScnScreenshots::Register();
 	CScnUtilities::Register();
 	CScnFileOp::Register();
 	CScnFileBrowser::Register();
	CScnAppConfig::Register();
    CFilesList::Register();
	XuiHtmlRegister();
    return CScnMain::Register();
}

HRESULT CMyApp::UnregisterXuiClasses()
{
    CGamesList::Unregister();
    CGenreList::Unregister();
	CScnMain::Unregister();
	CScnGames::Unregister();
 	CScnGenres::Unregister();
	CScnLoading::Unregister();
	CScnGameDetails::Unregister();
	CScnPickPath::Unregister();
	CScnOptions::Unregister();
	CScnOptionsMainScreen::Unregister();
	CScnOptionsGameList::Unregister();
	CScnOptionsSystemSettings::Unregister();
	CScnOptionsChooseSkin::Unregister();
	CScnScreenshots::Unregister();
	CScnUtilities::Unregister();
	CScnFileOp::Unregister();
	CScnAppConfig::Unregister();
	CScnFileBrowser::Unregister();
    CFilesList::Unregister();
	XuiHtmlUnregister();
    return S_OK;
}

void MountAll()
{
	memset(&Mounted,0,20);

 	Mounted[DEVICE_USB0] = Mount(DEVICE_USB0,"Usb0:");
 	Mounted[DEVICE_USB1] = Mount(DEVICE_USB1,"Usb1:");
 	Mounted[DEVICE_USB2] = Mount(DEVICE_USB2,"Usb2:");
 	Mounted[DEVICE_HARDISK0_PART1] = Mount(DEVICE_HARDISK0_PART1,"Hdd1:");
 	Mounted[DEVICE_HARDISK0_SYSPART] = Mount(DEVICE_HARDISK0_SYSPART,"HddX:");
 	Mounted[DEVICE_MEMORY_UNIT0] = Mount(DEVICE_MEMORY_UNIT0,"Memunit0:");
 	Mounted[DEVICE_MEMORY_UNIT1] = Mount(DEVICE_MEMORY_UNIT1,"Memunit1:");
	Mounted[DEVICE_MEMORY_ONBOARD] = Mount(DEVICE_MEMORY_ONBOARD,"OnBoardMU:"); 
	Mounted[DEVICE_CDROM0] = Mount(DEVICE_CDROM0,"Dvd:");
	Mounted[DEVICE_NAND_FLASH] = Mount(DEVICE_NAND_FLASH,"Flash:");
//	Mounted[DEVICE_TEST] = Mount(DEVICE_TEST,"TEST:");

	DebugMsg("Mount : DEVICE_USB0 - %d",Mounted[DEVICE_USB0]);
	DebugMsg("Mount : DEVICE_USB1 - %d",Mounted[DEVICE_USB1]);
	DebugMsg("Mount : DEVICE_USB2 - %d",Mounted[DEVICE_USB2]);
	DebugMsg("Mount : DEVICE_HARDISK0_PART1 - %d",Mounted[DEVICE_HARDISK0_PART1]);
	DebugMsg("Mount : DEVICE_HARDISK0_SYSPART - %d",Mounted[DEVICE_HARDISK0_SYSPART]);
	DebugMsg("Mount : DEVICE_MEMORY_UNIT0 - %d",Mounted[DEVICE_MEMORY_UNIT0]);
	DebugMsg("Mount : DEVICE_MEMORY_UNIT1 - %d",Mounted[DEVICE_MEMORY_UNIT1]);
	DebugMsg("Mount : DEVICE_MEMORY_ONBAORD - %d",Mounted[DEVICE_MEMORY_ONBOARD]);
	DebugMsg("Mount : DEVICE_CDROM0 - %d",Mounted[DEVICE_CDROM0]);
	DebugMsg("Mount : DEVICE_NAND_FLASH - %d",Mounted[DEVICE_NAND_FLASH]);
//	DebugMsg("Mount : DEVICE_TEST - %d",Mounted[DEVICE_TEST]);
}

// use png texture loader when a png file as the d3dx one leaks ram like a bitch with 8bit pngs, and several of the
// arcade icons are 8 bit. DOH!
HRESULT TextureLoader(IXuiDevice *pDevice, LPCWSTR szFileName, XUIImageInfo *pImageInfo, IDirect3DTexture9 **ppTex)
{
	int Len = wcslen(szFileName);
	if (szFileName[Len-3] == L'P' || szFileName[Len-3] == L'p')
		return XuiPNGTextureLoader(pDevice,szFileName,pImageInfo,ppTex);

	return XuiD3DXTextureLoader(pDevice,szFileName,pImageInfo,ppTex);
}

void LoadFonts(CMyApp &app)
{
	wstring file = L"game:\\Skin\\" + cl.skin + L"\\fonts.xml";
	if (!FileExists(file))
	{
		DebugMsg("Unable to find fonts.xml file %S",file.c_str());
		return;
	}

	XMLReader * xml = LoadConfigFile(file);
	while (xml && xml->read())
	{
		if (StartAttribute(xml,L"font"))
		{
			wstring filename = xml->getAttributeValue(L"file");
			wstring font = xml->getAttributeValue(L"name");

			filename = L"file://game:/Skin/" + cl.skin + L"/" + filename;
			DebugMsg("Loading font %S as %S",filename.c_str(),font.c_str());

			HRESULT hr = app.RegisterTypeface( font.c_str(), filename.c_str());
			DebugMsg("RegisterTypeface : %08x",hr);
		}
	}
}

VOID __cdecl main()
{
	// delete debug log
	//_unlink("game:\\debug.log"); MATTIE: Already done in XeDebug
	_unlink("game:\\ftp.log");

	StartDebugger(); //MATTIE: Start XeDebug connection

	HRESULT hr;

	// init network
	InitNetwork();

	// mount drives
	MountAll();

	// Declare an instance of the XUI framework application.
    CMyApp app;

	app.GetVidMode(); 

	D3DPRESENT_PARAMETERS d3dpp =
    {
        0
    };
    d3dpp.BackBufferWidth = app.dwWidth;
    d3dpp.BackBufferHeight = app.dwHeight;
    d3dpp.BackBufferFormat = D3DFMT_A8R8G8B8;
    d3dpp.BackBufferCount = 1;
    d3dpp.MultiSampleType = D3DMULTISAMPLE_NONE;
    d3dpp.SwapEffect = D3DSWAPEFFECT_DISCARD;
    d3dpp.PresentationInterval = D3DPRESENT_INTERVAL_DEFAULT;
    //d3dpp.PresentationInterval = D3DPRESENT_INTERVAL_IMMEDIATE;

    IDirect3D9* pD3D = Direct3DCreate9( D3D_SDK_VERSION );
    if( !pD3D ) {
        DebugMsg( "Failed to Direct3DCreate9" );
        return;
	} else {
		DebugMsg("D3D device created ok");
	}

    hr = pD3D->CreateDevice( 0, D3DDEVTYPE_HAL, NULL,
                                     D3DCREATE_HARDWARE_VERTEXPROCESSING, &d3dpp, &pDevice );
    if( FAILED( hr ) )
    {
        DebugMsg( "Failed to create Device" );
        return;
	}

    // Initialize the application.
    hr = app.InitShared( pDevice, &d3dpp, TextureLoader, NULL );
    if( FAILED( hr ) )
    {
        DebugMsg( "Failed intializing application.\n" );
        return;
    }
	
	if (FileExists(L"usb0:\\fsdata\\config.xml"))
	{
		datapath = L"usb0:\\fsdata\\";
		datapath_x = L"file://usb0:/fsdata/";
	} else if (FileExists(L"hdd1:\\fsdata\\config.xml"))
	{
		datapath = L"hdd1:\\fsdata\\";
		datapath_x = L"file://hdd1:/fsdata/";
	}

	// find a datapath and reboot
	if (datapath.empty())
	{
		CFTPServer ftp;
		ftp.CreateThread();

		XuiSoundXAudioRegister();
		XuiVideoRegister();

		hr = app.RegisterDefaultTypeface( L"Arial Unicode MS", L"file://game:/media/xarialuni.ttf" );
		hr = app.LoadSkin( L"file://game:/skin/NXE (List)/skin.xur" );
		hr = app.LoadFirstScene( L"file://game:/skin/NXE (List)/", L"pickpath.xur", NULL );
		app.Run();
		app.Uninit();
	}

	wstring file = datapath + L"favs.xml";
	_wunlink(file.c_str());
	file = datapath + L"display.xml";
	_wunlink(file.c_str());
	file = datapath + L"skin.xml";
	_wunlink(file.c_str());

	cl.LoadConfig();

	XNADDR addr;
	XNetGetTitleXnAddr(&addr);
	char ip[16];
	sprintf_s(ip, 16, "%d.%d.%d.%d", (byte)addr.ina.S_un.S_un_b.s_b1,
		(byte)addr.ina.S_un.S_un_b.s_b2,
		(byte)addr.ina.S_un.S_un_b.s_b3,
		(byte)addr.ina.S_un.S_un_b.s_b4
		);

	DebugMsg("XNetGetTitleXnAddr returned %s",ip);
	string sIp = ip;

	CFTPServer ftp;
	ftp.xboxip = strtowstr(sIp); //cl.xboxip; 
	ftp.port = cl.port; 
	ftp.ftpuser = cl.ftpuser; 
	ftp.ftppass = cl.ftppass; 
	ftp.CreateThread();

	//StartDebugger(cl.debugip.c_str(),cl.debugport);

	if (!FileExists(L"game:\\Skin\\" + cl.skin + L"\\skin.xur"))
		cl.skin = L"NXE (List)";

	DebugMsg("Using Skin %S",cl.skin.c_str());
 
	XuiSoundXAudioRegister();
	XuiVideoRegister();
	InitTexture();
//	ReadGamerPicture(m_GamerPic);
	// initialize skin
	hr = app.RegisterDefaultTypeface( L"Arial Unicode MS", L"file://game:/media/xarialuni.ttf" );
	LoadFonts(app);

	wstring skinmain = L"file://game:/skin/" + cl.skin + L"/skin.xur";
	hr = app.LoadSkin( skinmain.c_str() );
	DebugMsg("app.LoadSkin(%S) = %d",skinmain,hr);
	wstring skinfolder = L"file://game:/skin/" + cl.skin + L"/";

	DebugMsg("Starting scene loading");
	hr = app.LoadFirstScene( skinfolder.c_str(), L"loading.xur", NULL );
	DebugMsg("app.LoadFirstScene(%s) = %d",wstrtostr(skinfolder).c_str(),hr);
	
	// load data
	DebugMsg("Starting Loading Thread 1");
	lt = new LoadingThread();
	if(NTPonStartup)
	{
		NTP::SyncTime();
	}
	lt->CreateThread();

	app.Run();

    app.Uninit();

	EndDebugger(); //MATTIE: end XeDebug
}

void DoSaveSettings()
{
	DebugMsg("DoSaveSettings");
	wstring settingsxml;
	settingsxml.append(L"<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
	settingsxml.append(L"<config>\n");
	settingsxml.append(L"\t<paths>\n");
	for (int i = 0 ; i < 5 ; i++)
	{
		wstring sect = L"";
		switch (i)
		{
		case 0:
			sect = L"xboxlive";
			break;
		case 1:
			sect = L"xbox360";
			break;
		case 2:
			sect = L"xbox1";
			break;
		case 3:
			sect = L"homebrew";
			break;
		case 4:
			sect = L"emulators";
			break;
		}

		TypePaths * l = cl.Paths[i];

		settingsxml.append(sprintfa(L"\t\t<%s>\n",sect.c_str()));

		vector<wstring>::iterator itr;
		for (itr = l->path.begin() ; itr != l->path.end() ; itr++)
			settingsxml.append(sprintfa(L"\t\t\t<path>%s</path>\n",(*itr).c_str()));
	
		settingsxml.append(sprintfa(L"\t\t</%s>\n",sect.c_str()));
	}
	settingsxml.append(L"\t</paths>\n");

	settingsxml.append(L"\t<favs>\n");
	vector<ContentItem*>::iterator itr;
	for (itr = cl.Content.begin() ; itr != cl.Content.end() ; itr++)
	{
		ContentItem * it = (*itr);
		if (it->Favourite)
		{
			settingsxml.append(sprintfa(L"\t\t<fav>%s</fav>\n",it->shortpath.c_str()));
		}
	}
	settingsxml.append(L"\t</favs>\n");

	settingsxml.append(L"\t<recents>\n");
	for (itr = cl.Content.begin() ; itr != cl.Content.end() ; itr++)
	{
		ContentItem * it = (*itr);
		if (it->recent > 0)
			settingsxml.append(sprintfa(L"\t\t<recent no='%d'>%s</recent>\n",it->recent,it->shortpath.c_str()));
	}
	settingsxml.append(L"\t</recents>\n");

	settingsxml.append(sprintfa(L"\t<skin>%s</skin>\n",cl.skin.c_str()));
	settingsxml.append(sprintfa(L"\t<display horizoverscan='%d' vertoverscan='%d' />\n",HOverscan,VOverscan));
	settingsxml.append(sprintfa(L"\t<ftp xboxip='%s' port='%d' username='xbox' password='xbox' />\n",cl.xboxip.c_str(),cl.port,cl.ftpuser.c_str(),cl.ftppass.c_str()));
	//settingsxml.append(sprintfa("\t<debug host='%s' port='%d' />\n",cl.debugip.c_str(),cl.debugport));
	settingsxml.append(sprintfa(L"\t<gamelistopt background='%d' preview='%d' semitransparent='%d' />\n",UseBackgrounds,UsePreviews,SemiTransparentBackground));
	settingsxml.append(sprintfa(L"\t<mainscreenopt tempstatus='%d' diskstatus='%d' celsius='%d' parent='%d' showip='%d' showstatus='%d' />\n",TempStatus,DiskStatus,Cels,ParentalControl,ShowIP,ShowStatus));
	settingsxml.append(sprintfa(L"\t<moreoptions fanspeed='%d' ledformat='%d' />\n",FSpeed,LedType));
	settingsxml.append(sprintfa(L"\t<timeformat time='%d' date='%d' ntp='%d'/>\n",TimeFormat,DateFormat,NTPonStartup));
	settingsxml.append(L"</config>\n");


	int neededbuffer = WideCharToMultiByte(CP_UTF8,0,settingsxml.c_str(),-1,NULL,0,NULL,FALSE);
	DebugMsg("Needed buffer : %d",neededbuffer);
	if (neededbuffer == 0)
	{
		return;
	}
	char* buf2 = new char[neededbuffer];
	memset(buf2,0,neededbuffer);
	int res = WideCharToMultiByte(CP_UTF8,0,settingsxml.c_str(),-1,buf2,neededbuffer,NULL,FALSE);
	if (res == 0)
	{
		return;
	}

	string resu = buf2;
	StringToFileA(resu,wstrtostr(datapath + L"config.xml").c_str());

	delete buf2;

	SaveSettings = false;
}

WCHAR * ShortMonth(int iMonth)
{
	WCHAR * Month = NULL;

	switch (iMonth)
	{
	case 1:
		Month = L"Jan";
		break;
	case 2:
		Month = L"Feb";
		break;
	case 3:
		Month = L"Mar";
		break;
	case 4:
		Month = L"Apr";
		break;
	case 5:
		Month = L"May";
		break;
	case 6:
		Month = L"Jun";
		break;
	case 7:
		Month = L"Jul";
		break;
	case 8:
		Month = L"Aug";
		break;
	case 9:
		Month = L"Sep";
		break;
	case 10:
		Month = L"Oct";
		break;
	case 11:
		Month = L"Nov";
		break;
	case 12:
		Month = L"Dec";
		break;
	}

	return Month;
}

WCHAR * AMPM(SYSTEMTIME & LocalSysTime)
{
	if (LocalSysTime.wHour > 11)
		return L"pm";
	return L"am";
}

WCHAR * ShortDay(int Day)
{
	WCHAR * DOW = NULL;

	switch (Day)
	{
	case 0:
		DOW = L"Sun";
		break;
	case 1:
		DOW = L"Mon";
		break;
	case 2:
		DOW = L"Tue";
		break;
	case 3:
		DOW = L"Wed";
		break;
	case 4:
		DOW = L"Thu";
		break;
	case 5:
		DOW = L"Fri";
		break;
	case 6:
		DOW = L"Sat";
		break;
	}

	return DOW;
}

wstring GetDate(int Format, SYSTEMTIME & LocalSysTime)
{
	wstring date;


	switch (Format)
	{
	case 0: // Mon, 15 May, 2001
		date = sprintfa(L"%s, %d %s, %d",ShortDay(LocalSysTime.wDayOfWeek),LocalSysTime.wDay,ShortMonth(LocalSysTime.wMonth),LocalSysTime.wYear);
		break;
	case 1: // 2001-05-15
		date = sprintfa(L"%d-%d-%d",LocalSysTime.wYear,LocalSysTime.wMonth,LocalSysTime.wDay);
		break;
	case 2: // 15 May 2001
		date = sprintfa(L"%d %s %d",LocalSysTime.wDay,ShortMonth(LocalSysTime.wMonth),LocalSysTime.wYear);
		break;
	case 3: // 05/15/2001
		date = sprintfa(L"%d/%d/%d",LocalSysTime.wMonth,LocalSysTime.wDay,LocalSysTime.wYear);
		break;
	case 4: // 15/05/2001
		date = sprintfa(L"%d/%d/%d",LocalSysTime.wDay,LocalSysTime.wMonth,LocalSysTime.wYear);
		break;
	}

	return date;
}

wstring GetTime(int Format, SYSTEMTIME & LocalSysTime)
{
	int Hour = LocalSysTime.wHour % 12;
	wstring time;
	switch (Format)
	{
	case 0: // 5:16 pm
		time = sprintfa(L"%d:%02d %s",Hour,LocalSysTime.wMinute,AMPM(LocalSysTime));
		break;
	case 1: // 5:16:05 pm
		time = sprintfa(L"%d:%02d:%02d %s",Hour,LocalSysTime.wMinute,LocalSysTime.wSecond,AMPM(LocalSysTime));
		break;
	case 2: // 5:16 pm
		time = sprintfa(L"%d:%02d",LocalSysTime.wHour,LocalSysTime.wMinute);
		break;
	case 3: // 5:16:05 pm
		time = sprintfa(L"%d:%02d:%02d",LocalSysTime.wHour,LocalSysTime.wMinute,LocalSysTime.wSecond);
		break;
	}

	return time;
}
void InitTexture()
{
	 pDevice->CreateTexture(
            64,                     // Width
            64,                     // Height
            1,                      // Levels
            0,                      // Usage
            D3DFMT_LIN_A8R8G8B8,    // This is the only supported texture format for ReadPicture
            0,                      // Pool
            &gamerPic,
            NULL );
}
void ReadGamerPicture(CXuiImageElement & m_GamerPic)
{
	HRESULT hr;
	int m_CurrentPlayerIndex = 0;
	char gamerPicPath[256];
	

	D3DLOCKED_RECT rect;
	D3DSURFACE_DESC desc;
	hr = gamerPic->GetLevelDesc( 0, &desc );
	hr = gamerPic->LockRect(
		0,                      // Level (no mip-map)
		&rect,
		NULL,                   // Lock the whole texture
		0 );                    // Flags
	DWORD r= GetGamerPicture(m_CurrentPlayerIndex,(BYTE*)rect.pBits,false,rect.Pitch,desc.Height);
	
	gamerPic->UnlockRect( 0 );
	
	sprintf_s(gamerPicPath,256, "game:\\gamerpic%d.png", m_CurrentPlayerIndex);
	if(FileExists(strtowstr(gamerPicPath).c_str()))
	{
		unlink(gamerPicPath);
	}
	if(r!=-1)
	{
		if(SaveTextureToPNGFile(gamerPic,gamerPicPath  ))
		{
			//DebugMsg("Saved GamerPic file");
			char xuiPath[256] = {0};

			sprintf_s(xuiPath,256,"file://game:/gamerpic%d.png",m_CurrentPlayerIndex);
			m_GamerPic.SetImagePath(L"");
			m_GamerPic.SetImagePath(strtowstr(xuiPath).c_str());
		}
		else
		{
		//	DebugMsg("Failed to save gamerpic...");
			m_GamerPic.SetImagePath(L"");
		}
	}
	else
	{
	//	DebugMsg("Get GamerPic failed");
		m_GamerPic.SetImagePath(L"");
	}
}
void SetClock(CXuiTextElement & m_date,	CXuiTextElement & m_time, CXuiTextElement & m_datetime)
{
    SYSTEMTIME LocalSysTime;
    GetLocalTime( &LocalSysTime );
	wstring time = GetTime(TimeFormat, LocalSysTime);
	wstring date = GetDate(DateFormat, LocalSysTime);

	m_date.SetText(date.c_str());
	m_time.SetText(time.c_str());

	m_datetime.SetText(wstring(date + L" " + time).c_str());
}

void SetTemps(CXuiTextElement & m_CPUTemp,	CXuiTextElement & m_GPUTemp, CXuiTextElement & m_EDRAMTemp, CXuiTextElement & m_MBTemp, CXuiTextElement & m_StatusText)
{
	smc MySMC;
	wstring CPUString;
	wstring GPUString;
	wstring EDRAMString;
	wstring MBString;
	
	if (TempStatus == 1) {
		if (Cels == 1) {
			CPUString = sprintfa(L"CPU: %0.1f C\n", MySMC.GetTemperature(CPU,true));
			GPUString = sprintfa(L"GPU: %0.1f C\n", MySMC.GetTemperature(GPU,true));
			EDRAMString = sprintfa(L"RAM: %0.1f C\n", MySMC.GetTemperature(MEM,true));
			MBString = sprintfa(L"MB: %0.1f C\n", MySMC.GetTemperature(BRD,true));
		} else {
			CPUString = sprintfa(L"CPU: %0.1f F\n", MySMC.GetTemperature(CPU,false));
			GPUString = sprintfa(L"GPU: %0.1f F\n", MySMC.GetTemperature(GPU,false));
			EDRAMString = sprintfa(L"RAM: %0.1f F\n", MySMC.GetTemperature(MEM,false));
			MBString = sprintfa(L"MB: %0.1f F\n", MySMC.GetTemperature(BRD,false));
		}
		m_StatusText.SetText(L"System Temperature");
		m_CPUTemp.SetText(CPUString.c_str());
		m_GPUTemp.SetText(GPUString.c_str());
		m_EDRAMTemp.SetText(EDRAMString.c_str());
		m_MBTemp.SetText(MBString.c_str());
	} else {
		m_CPUTemp.SetText(NULL);
		m_GPUTemp.SetText(NULL);
		m_EDRAMTemp.SetText(NULL);
		m_MBTemp.SetText(NULL);
		m_StatusText.SetText(NULL);
	}
}

string GetIp()
{
	string ipa = "0.0.0.0";
	XNADDR xnaddr;
	IN_ADDR ipaddr, lipaddr;
	XNetGetTitleXnAddr( &xnaddr );
	ipaddr=xnaddr.ina;
	char szip[16];
	if (!memcmp(&ipaddr, &lipaddr, sizeof(ipaddr)))
	{
		XNetInAddrToString( ipaddr, szip, 16);
		ipa = sprintfaA("IP: %s", szip);
	}
	return ipa;
}

void SetIp(CXuiTextElement & m_IPAddy)
{
	if (ShowIP == 1) {
		string ip = GetIp();
		m_IPAddy.SetText(strtowstr(ip).c_str());
	} else {
		m_IPAddy.SetText(NULL);
	}
}

void SetDiskSpace(CXuiTextElement & m_HDD1Text, CXuiTextElement & m_HDD0Text, CXuiTextElement & m_USB1Text, CXuiTextElement & m_USB0Text, CXuiTextElement & m_DiskStatus )
{
	if (DiskStatus == 1) {
		string usb0space;
		string usb1space;
		string hdd0space;
		string hdd1space;
		m_DiskStatus.SetText(L"Free Space on Disk");


		if (Mounted[DEVICE_USB0]){
			usb0space = "USB0:";
			usb0space.append(GetDiskSpace("usb0:"));
			m_USB0Text.SetText(strtowstr(usb0space).c_str());			
		} else {
			m_USB0Text.SetText(NULL);
		}
		if (Mounted[DEVICE_USB1]){
			usb1space = "USB1:";
			usb1space.append(GetDiskSpace("usb1:"));
			m_USB1Text.SetText(strtowstr(usb1space).c_str());
		} else {
			m_USB1Text.SetText(NULL);
		}
		if (Mounted[DEVICE_MEMORY_UNIT0]){
			hdd0space = "MU0:";
			hdd0space.append(GetDiskSpace("memunit0:"));
			m_HDD0Text.SetText(strtowstr(hdd0space).c_str());
		} else {
			m_HDD0Text.SetText(NULL);
		}
		if (Mounted[DEVICE_HARDISK0_PART1]){
			hdd1space = "HDD1:";
			hdd1space.append(GetDiskSpace("hdd1:"));
			m_HDD1Text.SetText(strtowstr(hdd1space).c_str());
		} else {
			m_HDD1Text.SetText(NULL);
		}
	} else {
		m_USB0Text.SetText(NULL);
		m_USB1Text.SetText(NULL);
		m_HDD1Text.SetText(NULL);
		m_HDD0Text.SetText(NULL);
		m_DiskStatus.SetText(NULL);
	}

}

string GetDiskSpace(string drive)
{
	string file = drive + "\\";
	ULARGE_INTEGER FreeBytesAvailable;
	ULARGE_INTEGER TotalNumberOfBytes;
	ULARGE_INTEGER TotalNumberOfFreeBytes;

	GetDiskFreeSpaceEx(file.c_str(),&FreeBytesAvailable,&TotalNumberOfBytes,&TotalNumberOfFreeBytes);

	string result;
	
	if (TotalNumberOfBytes.QuadPart > 1024*1024*1024)
	{
		result = sprintfaA(" %0.1fGB",(float)(TotalNumberOfFreeBytes.QuadPart)/(1024.0f*1024.0f*1024.0f));
	} else {
		result = sprintfaA(" %0.1fMB",(float)(TotalNumberOfFreeBytes.QuadPart)/(1024.0f*1024.0f));
	}

	return result;
}

void SetGamerTag(CXuiTextElement & m_GamerTag) 
 { 
         char gamertag[100] ={0}; 
         GetGamerTag(0,gamertag); 
         string gamertagstring = sprintfaA("%s", gamertag); 
          
         m_GamerTag.SetText(strtowstr(gamertagstring).c_str()); 
 } 
 

void SetGamerScore(CXuiTextElement & m_GamerScore)
{
	string gamerscorestring = sprintfaA("%d", GetGamerPoints(0));
	
	m_GamerScore.SetText(strtowstr(gamerscorestring).c_str());
}

void SetInfoText(CXuiTextElement & m_SMCVer, CXuiTextElement & m_TrayStat, CXuiTextElement & m_Orientation, CXuiTextElement & m_AVPack, CXuiTextElement & m_InfoText )
{
	if (ShowStatus)
	{
	smc MySMC;
	m_InfoText.SetText(L"Status Information");
	string smcversion = sprintfaA("SMC: %s\n", MySMC.GetSMCVersion());
	m_SMCVer.SetText(strtowstr(smcversion).c_str());
	//string IPAddress = sprintfaA("IP Address: %s\n\n", GetIp());
	string tilt = sprintfaA("Tilt: %s\n", (MySMC.GetTiltState() == VERTICAL) ? "Vertical" : "Horizontal");
	m_Orientation.SetText(strtowstr(tilt).c_str());

// Thanks goto Aaron for this
// Setting Names to AV Packs
const char* avpackname = MySMC.GetAVPackName();
string avpack;
if (avpackname)
	avpack = sprintfaA("AV Pack: %s\n", MySMC.GetAVPackName());
else
	avpack = sprintfaA("AV Pack: 0x%02x\n", MySMC.GetAVPack());
	m_AVPack.SetText(strtowstr(avpack).c_str());

	//MATTIE: wrong info?
	//char* states[] = {"Open", "Opening", "Closed", "Closing", "Pushed"};
	char* states[] = {"Open", "-", "Closed", "Opening", "Closing"};
	string tray = sprintfaA("Tray: %s\n", states[MySMC.GetTrayState()]);
	m_TrayStat.SetText(strtowstr(tray).c_str());
	} else {
		m_InfoText.SetText(NULL);
		m_SMCVer.SetText(NULL);
		m_Orientation.SetText(NULL);
		m_TrayStat.SetText(NULL);
		m_AVPack.SetText(NULL);
	}
}

void SetTempLEDS()   //Thanks to p4r0l3
{
    smc mySMC;
    
    float temperature[4];
    int delta = 0;

	temperature[0] = mySMC.GetTemperature(CPU,true);
	temperature[1] = mySMC.GetTemperature(GPU,true);
	temperature[2] = mySMC.GetTemperature(MEM,true);
	temperature[3] = mySMC.GetTemperature(BRD,true);

    if (temperature[0]<=50){
        if (sTopLeft != GREEN){
            sTopLeft = GREEN;
            delta=1;}}
    else if (temperature[0]<=60){
        if (sTopLeft != ORANGE){
            sTopLeft = ORANGE;
            delta = 1;}}
    else{
        if (sTopLeft != RED){
            sTopLeft = RED;
            delta = 1;}}

    if (temperature[1]<=50){
        if (sTopRight != GREEN){
            sTopRight = GREEN;
            delta=1;}}
    else if (temperature[1]<=60){
        if (sTopRight != ORANGE){
            sTopRight = ORANGE;
            delta = 1;}}
    else{
        if (sTopRight != RED){
            sTopRight = RED;
            delta = 1;}}

    if (temperature[2]<=50){
        if (sBottomLeft != GREEN){
            sBottomLeft = GREEN;
            delta=1;}}
    else if (temperature[2]<=60){
        if (sBottomLeft != ORANGE){
            sBottomLeft = ORANGE;
            delta = 1;}}
    else{
        if (sBottomLeft != RED){
            sBottomLeft = RED;
            delta = 1;}}

    if (temperature[3]<=50){
        if (sBottomRight != GREEN){
            sBottomRight = GREEN;
            delta=1;}}
    else if (temperature[3]<=60){
        if (sBottomRight != ORANGE){
            sBottomRight = ORANGE;
            delta = 1;}}
    else{
        if (sBottomRight != RED){
            sBottomRight = RED;
            delta = 1;}}

    if (delta==1)
        mySMC.SetLEDS(sTopLeft,sTopRight,sBottomLeft,sBottomRight);
}

void SetLedState(int Format)
{
	smc MySMC;

	switch (Format)
	{
	case 0: // All Off
		MySMC.SetLEDS(OFF,OFF,OFF,OFF);
		break;
	case 1: // Temperature
		break;
	case 2: // Green
		MySMC.SetLEDS(GREEN,GREEN,GREEN,GREEN);
		break;
	case 3: // Orange
		MySMC.SetLEDS(ORANGE,ORANGE,ORANGE,ORANGE);
		break;
	case 4: // Red
		MySMC.SetLEDS(RED,RED,RED,RED);
		break;
	}
}

void SetFanSpeed(int fan, int speed)
{
	smc MySMC;

	MySMC.SetFanSpeed(fan, speed);

}

void RestartFreestyle()
{
	if (FileExists(L"game:\\FreestyleDash.xex"))
		XLaunchNewImage("game:\\FreestyleDash.xex",0);		

	if (FileExists(L"game:\\default.xex"))
		XLaunchNewImage("game:\\default.xex",0);		
}